/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2008-09-16
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef COORDINATEFILE_H
#define COORDINATEFILE_H

#include <QGpCoreTools.h>
#include "QGpGuiToolsDLLExport.h"

namespace QGpGuiTools {

  class QGPGUITOOLS_EXPORT CoordinateFile
  {
    TRANSLATIONS("CoordinateFile")
  public:
    CoordinateFile();
    ~CoordinateFile();

    bool read(QString fileName=QString::null, QString format=QString::null);
    static bool write(const QList<NamedPoint>& points, QString fileName=QString::null);

    bool contains(const QString& name) const;
    const QList<NamedPoint>& points() const {return _points;}

    static const QString fileFilter;
  private:
    bool parse(const ColumnTextParser * parser, bool localProjection, const Point2D& reference);

    QList<NamedPoint> _points;
  };

} // namespace QGpGuiTools

#endif // COORDINATEFILE_H
