/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2006-01-11
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef DIALOG_H
#define DIALOG_H

#include "QGpGuiToolsDLLExport.h"
#include "Settings.h"

namespace QGpGuiTools {

class QGPGUITOOLS_EXPORT FrameGrabber
{
public:
  FrameGrabber() {_valid=false;_lock=5;}

  void setRect( QWidget * w, QString name );
protected:
  inline void setFrame(QWidget * w);
private:
  int _x, _y, _width, _height;
  int _lock;
  bool _valid;
};

inline void FrameGrabber::setFrame(QWidget * w)
{
  TRACE;
  if ( w->isVisible() ) {
    if (_lock==0) {
      _x=w->x();
      _y=w->y();
      _width=w->width();
      _height=w->height();
      _valid=true;
    } else {
      _lock--;
    }
  }
}

class QGPGUITOOLS_EXPORT Dialog : public QDialog, public FrameGrabber
{
  Q_OBJECT
public:
  Dialog(QWidget * parent=0, Qt::WFlags f=0);

  void setRect(QString name) {FrameGrabber::setRect(this, name);}
  void getRect(QString name) {Settings::getRect(this, name);}

  enum Buttons {OkCancel, Close};

  void addWidget(QWidget * w);
  void addButtons(Buttons b=OkCancel);
  void setMainWidget( QWidget * w, Buttons b=OkCancel);
protected:
  virtual void resizeEvent(QResizeEvent * e);
  virtual void moveEvent(QMoveEvent * e);
private:
  QVBoxLayout * _vboxLayout;
};

class QGPGUITOOLS_EXPORT FileDialog: public QFileDialog, public FrameGrabber
{
  Q_OBJECT
public:
  FileDialog(QWidget * parent, Qt::WFlags flags) : QFileDialog(parent, flags) {}
  FileDialog(QWidget * parent=0, const QString & caption=QString::null, const QString & directory=QString::null, const QString & filter=QString::null)
    : QFileDialog(parent, caption, directory, filter) {}

  void setRect(QString name) {FrameGrabber::setRect(this, name);}
  void getRect(QString name) {Settings::getRect(this, name);}
protected:
  virtual void resizeEvent(QResizeEvent * e);
  virtual void moveEvent(QMoveEvent * e);
};

} // namespace QGpGuiTools

#endif // DIALOG_H
