/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2008-03-30
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef EXPANDTABTITLE_H
#define EXPANDTABTITLE_H

#include <QtGui>
#include <QGpCoreTools.h>

#include "QGpGuiToolsDLLExport.h"

namespace QGpGuiTools {

class QGPGUITOOLS_EXPORT ExpandTabTitle : public QWidget
{
  Q_OBJECT
  Q_PROPERTY( QString title READ title WRITE setTitle )
  Q_PROPERTY( bool expanded READ expanded WRITE setExpanded )
public:
  ExpandTabTitle( QWidget * parent=0 );
  ~ExpandTabTitle();

  void setTitle( QString t ) { _title = t; }
  QString title() const { return _title; }

  void setContent( QWidget * w ) { _content = w; }
  QWidget * content() const { return _content; }

  bool expanded() const { return _expanded; }
  void setExpanded(bool e);

  bool docked() const { return _docked; }
  void setDocked(bool d) { _docked = d; }
signals:
  void moveUp();
  void moveDown();
  void dock();
  void addActions( QMenu * );
  void resize( int dy );
protected:
  virtual void contextMenuEvent( QContextMenuEvent * e );
  virtual void paintEvent( QPaintEvent * e );
  virtual void mousePressEvent( QMouseEvent * e );
  virtual void mouseReleaseEvent( QMouseEvent * e );
  virtual void mouseMoveEvent( QMouseEvent * e );
  virtual QSize minimumSizeHint() const;
private:
  QString _title;
  QWidget * _content;
  int _resizeStart;
  uint _expanded:1;
  uint _docked:1;
  uint _expandPress:1;
  uint _moveUpPress:1;
  uint _moveDownPress:1;
  uint _dockPress:1;
  uint _expandHover:1;
  uint _moveUpHover:1;
  uint _moveDownHover:1;
  uint _dockHover:1;

  inline QRect expandRect() const;
  inline QRect moveUpRect() const;
  inline QRect moveDownRect() const;
  inline QRect dockRect() const;
  static const int _spacing;
  static const int _expandSize;
  static const int _upDownSize;
};

} // namespace QGpGuiTools

#endif // EXPANDTABTITLE_H
