/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2008-10-15
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef EXPRESSIONEDITOR_H
#define EXPRESSIONEDITOR_H

#include <QtGui>
#include <QGpCoreTools.h>

#include "ui_ExpressionEditor.h"
#include "QGpGuiToolsDLLExport.h"

namespace QGpGuiTools {

class QGPGUITOOLS_EXPORT ExpressionEditor : public QWidget, private Ui::ExpressionEditor
{
  Q_OBJECT
public:
  ExpressionEditor( QWidget * parent=0 );
  ~ExpressionEditor();

  void setContext( const ExpressionContext& c );
  void setReadOnly( bool ro );

  void setText( const QString& t );
  QString text() const;
private slots:
  void on_variableList_activated( int index );
  void on_operatorList_activated( int index );
  void on_functionList_activated( int index );
  void on_codeEdit_cursorPositionChanged();
};

} // namespace QGpGuiTools

#endif // EXPRESSIONEDITOR_H
