/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2005-10-04
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef GUIMESSAGE_H
#define GUIMESSAGE_H

#include <QGpCoreTools.h>
#include "QGpGuiToolsDLLExport.h"

namespace QGpGuiTools {

class QGPGUITOOLS_EXPORT GuiMessage : public QObject, public Message
{
  Q_OBJECT
public:
  GuiMessage();

private slots:
  void asyncMessageSlot( Message::Answer * a, QWaitCondition * reply, uint msgId,
                int sev, QString caption, const QString & text,
                QString answer0, QString answer1, QString answer2,
                bool againOption );
  void asyncGetOpenFileNameSlot( QString * a, QWaitCondition * reply,
                                   const QString & caption, const QString & filter, const QString & directory );
  void asyncGetSaveFileNameSlot( QString * a, QWaitCondition * reply,
                                   const QString & caption, const QString & filter, const QString & selection );
  void asyncGetOpenFileNamesSlot( QStringList * a, QWaitCondition * reply,
                                    const QString & caption, const QString & filter, const QString & directory );
  void asyncGetExistingDirectorySlot( QString * a, QWaitCondition * reply,
                                        const QString & caption, const QString & dir );
signals:
  void asyncMessageSignal( Message::Answer * a, QWaitCondition * reply, uint msgId,
                int sev, QString caption, const QString & text,
                QString answer0, QString answer1, QString answer2,
                bool againOption );
  void asyncGetOpenFileNameSignal( QString * a, QWaitCondition * reply,
                                   const QString & caption, const QString & filter, const QString & directory );
  void asyncGetSaveFileNameSignal( QString * a, QWaitCondition * reply,
                                   const QString & caption, const QString & filter, const QString & selection );
  void asyncGetOpenFileNamesSignal( QStringList * a, QWaitCondition * reply,
                                    const QString & caption, const QString & filter, const QString & directory );
  void asyncGetExistingDirectorySignal( QString * a, QWaitCondition * reply,
                                        const QString & caption, const QString & dir );
private:
  virtual QString getOpenFileNameInternal( const QString & caption,
                                   const QString & filter = QString::null,
                                   const QString & directory = QString::null );

  virtual QString getSaveFileNameInternal( const QString & caption,
                                   const QString & filter = QString::null,
                                   const QString & selection = QString::null );

  virtual QStringList getOpenFileNamesInternal( const QString & caption,
                                        const QString & filter = QString::null,
                                        const QString & directory = QString::null );

  virtual QString getExistingDirectoryInternal( const QString & caption,
                                        const QString & dir = QString::null );
  virtual Message::Answer message( uint msgId,
                                      Severity sev,
                                      QString caption,
                                      const QString & text,
                                      QString answer0,
                                      QString answer1,
                                      QString answer2,
                                      bool againOption );
};

} // namespace QGpGuiTools

#endif // GUIMESSAGE_H
