/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-01-04
**  Authors:
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef HTTPPROXYLIST_H
#define HTTPPROXYLIST_H

#include "QGpGuiToolsDLLExport.h"
#include "HttpProxy.h"

class QNetworkReply;

namespace QGpGuiTools {

  class QGPGUITOOLS_EXPORT HttpProxyList : public QObject
  {
    Q_OBJECT
  public:
    HttpProxyList(const QString& testUrl, QObject * parent=0);
    ~HttpProxyList();

    void collect();
    bool isReady() const {return _replies.isEmpty();}

    const HttpProxy& at(int index) {return _proxies[index];}
    int count() const {return _proxies.count();}

    const QUrl& testUrl() const {return _testUrl;}

    void printDebug(const QString& s, bool list=false) const;
  signals:
    void ready();
  private slots:
    void getScriptFinished();
  private:
    void sort();
    void getScript(const QString& url);
    void autoDetectProxies();
    void dnsDetectRequest(const QString& domainName);
    void replyReceived(QNetworkReply * reply);

    void firefoxProxies();
#if defined Q_WS_X11
    void kdeProxies();
#elif defined Q_WS_WIN
    void internetExplorerProxies();
#elif defined Q_WS_MAC
    void macProxies();
#endif
    void systemProxies();
    void firefoxProxies(const QString& file);
#if defined Q_WS_X11
    void kdeProxies(const QString& file);
#endif
    QStringList firefoxFiles();
    QStringList findFiles( QDir in, QString pattern);
    QStringList findFiles( QDir in, QStringList patternList);

    QUrl _testUrl;
    QList<HttpProxy> _proxies;
    QList<QNetworkReply *> _replies;
  };

} // namespace QGpGuiTools

#endif // HTTPPROXYLIST_H
