/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-06-24
**  Authors:
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef MULTIDOCUMENTENVIRONMENT_H
#define MULTIDOCUMENTENVIRONMENT_H

#include <QtGui>

#include "QGpGuiToolsDLLExport.h"

namespace QGpGuiTools {

  class MultiDocumentWindow;

  class QGPGUITOOLS_EXPORT MultiDocumentEnvironment : public QObject
  {
    Q_OBJECT
  public:
    MultiDocumentEnvironment(QObject * parent=0);
    ~MultiDocumentEnvironment();

    static MultiDocumentEnvironment * instance() {return _instance;}

    void addFileActions(QMenu * m, QToolBar * tb);
    void addEditActions(QMenu * m, QToolBar * tb);
    void addViewActions(QMenu * m, QToolBar * tb);
    void addWindowsActions(QMenu * m);
    void addHelpActions(QMenu * m);

    QAction * _fileNewAction;
    QAction * _fileOpenAction;
    QAction * _fileSaveAction;
    QAction * _fileSaveAsAction;
    QAction * _filePrintAction;
    QAction * _fileQuitAction;

    QAction * _editUndoAction;
    QAction * _editRedoAction;
    QAction * _editCutAction;
    QAction * _editCopyAction;
    QAction * _editPasteAction;

    QAction * _windowsNewWindowAction;

    QAction * _helpDocumentationAction;
    QAction * _helpWhatsThisAction;
    QAction * _helpAboutAction;
    QAction * _helpAboutQtAction;

    const QList<MultiDocumentWindow *>& windows() const {return _windows;}
    MultiDocumentWindow * currentWindow() const;
  public slots:
    virtual void newDocument();
    virtual void openDocument();
    virtual void saveDocument();
    virtual void saveDocumentAs();
    virtual void printDocument();
    virtual bool quit();

    virtual void undo();
    virtual void redo();
    virtual void cut();
    virtual void copy();
    virtual void paste();

    virtual void helpDocumentation();
    virtual void helpAbout();

    virtual MultiDocumentWindow * addWindow();
  protected:
    void createFileActions();
    void createEditActions();
    void createViewActions();
    void createWindowsActions();
    void createHelpActions();
    virtual MultiDocumentWindow * createWindow();
  protected slots:
    virtual void askForClose(bool& ok) {ok=true;}
  private slots:
    void clearCloseMarks();
    void removeWindow(QObject * windowObject);
  private:
    static MultiDocumentEnvironment * _instance;
    QList<MultiDocumentWindow *> _windows;
  };

} // namespace QGpGuiTools

#endif // MULTIDOCUMENTENVIRONMENT_H
