/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-06-22
**  Authors:
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef MULTIDOCUMENTSUBWINDOW_H
#define MULTIDOCUMENTSUBWINDOW_H

#include <QtGui>
#include <QGpCoreTools.h>

#include "QGpGuiToolsDLLExport.h"

namespace QGpGuiTools {

  class MultiDocumentTab;

  class QGPGUITOOLS_EXPORT MultiDocumentSubWindow : public QMdiSubWindow
  {
    Q_OBJECT
  public:
    MultiDocumentSubWindow(QWidget * parent=0, Qt::WindowFlags flags=0);
    ~MultiDocumentSubWindow();

    QAction * windowMenuAction() const {return _windowMenuAction;}
    void setWindowIcon(const QIcon & icon);
    MultiDocumentTab * tab() const;

    void setCloseMark(bool c=true) {_markedForClose=c;}
    bool markedForClose() const {return _markedForClose;}
  public slots:
    void setWindowTitle(const QString & t);
    void show();
  private slots:
    void windowsMenuTriggered();
  signals:
    void clearCloseMarks();
    void askForClose(bool& ok);
  protected:
    virtual void closeEvent(QCloseEvent * e);
  private:
    QAction * _windowMenuAction;
    bool _markedForClose;
  };

} // namespace QGpGuiTools

#endif // MULTIDOCUMENTSUBWINDOW_H
