/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-06-23
**  Authors:
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef MULTIDOCUMENTTABWIDGET_H
#define MULTIDOCUMENTTABWIDGET_H

#include <QtGui>

#include "QGpGuiToolsDLLExport.h"

namespace QGpGuiTools {

  class MultiDocumentTab;

  class QGPGUITOOLS_EXPORT MultiDocumentTabWidget : public QTabWidget
  {
    Q_OBJECT
  public:
    MultiDocumentTabWidget(QWidget * parent=0);
    ~MultiDocumentTabWidget();

    void addTab(MultiDocumentTab * t);
    void insertTab(int at, MultiDocumentTab * t);
    MultiDocumentTab * tab(int index);
  signals:
    void newTabRequested(int at);
    void closeTabRequested(int at);
  private slots:
    void renameTab(int at);
  };

} // namespace QGpGuiTools

#endif // MULTIDOCUMENTTABWIDGET_H
