/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2008-09-14
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef MULTIDOCUMENTWINDOW_H
#define MULTIDOCUMENTWINDOW_H

#include <QtGui>
#include <QGpCoreTools.h>
#include "QGpGuiToolsDLLExport.h"

namespace QGpGuiTools {

  class MultiDocumentTabWidget;
  class MultiDocumentTab;
  class MultiDocumentSubWindow;

  class QGPGUITOOLS_EXPORT MultiDocumentWindow : public QMainWindow
  {
    Q_OBJECT
  public:
    MultiDocumentWindow(QWidget * parent=0, Qt::WindowFlags f=0);
    ~MultiDocumentWindow();

    void setCloseMarks(bool c=true);

    virtual void newDocument() {}
    virtual void openDocument() {}
    virtual void saveDocument() {}
    virtual void saveDocumentAs() {}
    virtual void printDocument() {}
  public slots:
    void addWindow(MultiDocumentSubWindow * w);

    void addTab();
    void insertTab(int at);
  private slots:
    void closeSubWindow();
    void closeAllSubWindows();
    void closeTab(int at=-1);
    void closeAllTabs();
    void cascadeSubWindows();
    void tileSubWindows();
    void setCurrentSubWindow(QMdiSubWindow * w);
    void showToolBarMenu();
  signals:
    void clearCloseMarks();
    void askForClose(bool& ok);
    void activeWindowChanged(MultiDocumentSubWindow * w);
  protected:
    QAction * _windowsNewTabAction;
    QAction * _windowsCloseAction;
    QAction * _windowsCloseAllSubWindowsAction;
    QAction * _windowsCloseTabAction;
    QAction * _windowsCloseAllTabsAction;
    QAction * _windowsCascadeAction;
    QAction * _windowsTileAction;
    QMenu * _toolBarsMenu;
    QAction * _windowsToolBarsAction;

    QMenu * _fileMenu;
    QToolBar * _fileBar;
    QMenu * _editMenu;
    QToolBar * _editBar;
    QMenu * _viewMenu;
    QToolBar * _viewBar;
    QMenu * _windowsMenu;
    QMenu * _helpMenu;

    virtual void closeEvent(QCloseEvent * e);
    void addFileActions();
    void addEditActions();
    void addViewActions();
    void createWindowsActions();
    void addWindowsActions();
    virtual void addWindowsActions(QMenu * m);
    void addHelpActions();
  private:
    MultiDocumentTab * tab(int index) const;
    void setWindowsMenuEnabled(bool b);

    MultiDocumentTabWidget * _tabs;
  };

} // namespace QGpGuiTools

#endif // MULTIDOCUMENTWINDOW_H
