/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2010-02-28
**  Authors :

**
***************************************************************************/

#ifndef NUMERICALLINEEDIT_H
#define NUMERICALLINEEDIT_H

#include <QtGui>
#include <QGpCoreTools.h>

#include "QGpGuiToolsDLLExport.h"

namespace QGpGuiTools {

class QGPGUITOOLS_EXPORT NumericalLineEdit : public QLineEdit
{
  Q_OBJECT
public:
  NumericalLineEdit(QWidget * parent=0);

  void setValue(double v, Number::Type type=Number::Fixed, int precision=-6);
  double value(bool * ok=0) const;

  // Force error for migration from QLineEdit
  void setText() {}
  QString text(double) const {return QLineEdit::text();}
};

} // namespace QGpGuiTools

#endif // NUMERICALLINEEDIT_H
