/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2003-08-22
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef PrintParametersInt_H
#define PrintParametersInt_H

#include <QtGui>
#include <QGpCoreTools.h>

namespace QGpGuiTools {

class PrintParametersInt :  public QObject
{
  Q_OBJECT
  Q_PROPERTY (QString orientationHelp READ orientationHelp)
  Q_PROPERTY (QString pageSizeHelp READ pageSizeHelp)
  Q_PROPERTY (QString colorModeHelp READ colorModeHelp)
  Q_PROPERTY (QString pageOrderHelp READ pageOrderHelp)
  Q_PROPERTY (QString orientation READ orientation WRITE setOrientation)
  Q_PROPERTY (QString pageSize READ pageSize WRITE setPageSize)
  Q_PROPERTY (QString colorMode READ colorMode WRITE setColorMode)
  Q_PROPERTY (QString pageOrder READ pageOrder WRITE setPageOrder)
  Q_PROPERTY (int fromPage READ fromPage WRITE setFromPage)
  Q_PROPERTY (int toPage READ toPage WRITE setToPage)
  Q_PROPERTY (int numCopies READ numCopies WRITE setNumCopies)
  Q_PROPERTY (QString currentSettings READ currentSettings)
public:
  PrintParametersInt(QObject * parent=0);
  QString orientationHelp() const {return "Portrait, Landscape";}
  QString pageSizeHelp() const {return "A4, B5, Letter, Legal, Executive, A0, A1, A2, A3, A5, A6, "
                                "A7, A8, A9, B0, B1, B10, B2, B3, B4, B6, B7, B8, B9, C5E, "
                                "Comm10E, DLE, Folio, Ledger, Tabloid,Custom";}
  QString colorModeHelp() const {return "GrayScale, Color";}
  QString pageOrderHelp() const {return "FirstPageFirst, LastPageFirst";}
  
  QString orientation() const;
  QString pageSize() const;
  QString colorMode() const;
  QString pageOrder() const;
  int fromPage() const {return _from;}
  int toPage() const {return _to;}
  int numCopies() const  {return _numCopies;}
  
  void setOrientation(QString val);
  void setPageSize(QString val);
  void setColorMode(QString val);
  void setPageOrder(QString val);
  void setFromPage(int val) {if (val>_to) {_from=_to;_to=val;} else _from=val;}
  void setToPage(int val) {if (val<_from) {_to=_from;_from=val;} else _to=val;}
  void setNumCopies (int val) {if(val>0) _numCopies=val;}
  
  QString currentSettings() const;
protected:
  friend class QSA;
  QPrinter::Orientation _orientation;
  QPrinter::PageSize _pageSize;
  QPrinter::ColorMode _colorMode;
  QPrinter::PageOrder _pageOrder;
  int _from;
  int _to;
  int _numCopies;
};

} // namespace QGpGuiTools

#endif // PRINTPARAMETERSINT_H
