/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2008-03-31
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef PROPERTYEDITOR_H
#define PROPERTYEDITOR_H

#include "ExpandTabWidget.h"
#include "Application.h"

namespace QGpGuiTools {

class PropertyProxy;
class PropertyWidget;
class PropertyCategorySettings;
class PropertyArea;

class PropertyEditor : public QWidget, public GlobalObject
{
  Q_OBJECT
public:
  PropertyEditor( QWidget * parent = 0 );
  ~PropertyEditor();

  void setProxy( PropertyProxy * proxy );
  PropertyProxy * proxy() const { return _proxy; }

  void addCategory(QIcon icon, QString caption, ExpandTabWidget * w);
  void removeCategory( QString category );
  void addTab(QString category, QString title, PropertyWidget * w);
  ExpandTabWidget * widget( QString category );
  void takeWidgets();

  void saveStates();
  void restoreStates();

  static PropertyEditor * instance() { return _instance; }
protected:
  virtual bool eventFilter ( QObject * watched, QEvent * event );
  virtual void resizeEvent( QResizeEvent * );
  virtual void moveEvent( QMoveEvent * );
private slots:
  void currentCategoryChanged( int index );
private:
  void saveState( int index );
  void restoreState( int index );

  QTabWidget * _tab;
  QMap<QString, QWidget *> _categories;
  QMap<ExpandTabWidget *, PropertyArea *> _propertyAreas;
  PropertyProxy * _proxy;
  QMap<QString, PropertyCategorySettings *> _categorySettings;
  static PropertyEditor * _instance;
};

} // namespace QGpGuiTools

#endif // PROPERTYEDITOR_H
