/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2008-03-31
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef PROPERTYTAB_H
#define PROPERTYTAB_H

#include <QtGui>

namespace QGpGuiTools {

class PropertyItem;
class PropertyWidget;

class PropertyTab : public QObject
{
  Q_OBJECT
public:
  PropertyTab();
  ~PropertyTab();

  void setTitle( QString t ) { _title = t; }
  QString title() const { return _title; }

  void setWidget( PropertyWidget * w );
  PropertyWidget * widget() const { return _widget; }

  void addReference( PropertyItem * item );
  void removeReference( PropertyItem * item );
  bool hasReference() const { return !_references.isEmpty(); }
  bool contains( PropertyItem * item );
public slots:
  void setValues();
private slots:
  void widgetDestroyed(QObject *);
  void setProperty( int id, QVariant val );
private:
  QString _title;
  PropertyWidget * _widget;
  QSet<PropertyItem *> _references;
  PropertyItem * _currentItem;
};

} // namespace QGpGuiTools

#endif // PROPERTYTAB_H
