/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2008-04-01
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef PROPERTYWIDGET_H
#define PROPERTYWIDGET_H

#include "QGpGuiToolsDLLExport.h"
#include "PropertyValue.h"

namespace QGpGuiTools {

class PropertyItem;

class QGPGUITOOLS_EXPORT PropertyWidget : public QWidget
{
  Q_OBJECT
public:
  PropertyWidget( QWidget * parent=0 );
  ~PropertyWidget();

  void setValue(int pid, QVariant val);
  QVariant value(int pid) {return _list[pid]->value();}
  bool constant(int pid) {return _list[pid]->constant();}
  PropertyValue * propertyValue(int pid) {return _list[pid];}
  int propertyCount() const {return _list.count();}

  virtual void setWidgets();
  virtual void reset();

  void setId(uint wid) { _wid = wid; }
  uint id() const { return _wid; }

  void linkTo( PropertyWidget * w );

  void touched(PropertyValue * p, QVariant val );
private slots:
  void touched(PropertyValue * p) { touched( p, widgetValue( *p ) ); }
signals:
  void setProperty( int id, QVariant val );
  void refreshValues();
  void touched();
protected:
  PropertyValue * addProperty( int pid, QWidget * w, QWidget * label );
  PropertyValue * addProperty( int pid, QWidget * w = 0 ) { return addProperty(pid, w, w); }

  virtual int determineCustomWidgetType( int /* pid */, QWidget * /* w */, QWidget * /* label */ ) { return 0; }
  virtual bool connectCustomWidget( PropertyValue & /* p */ ) { return false; }
  virtual bool setCustomWidget( PropertyValue & /* p */ )  { return false; }
  virtual QVariant customWidgetValue( PropertyValue & /* p */ ) { return QVariant(); }
private:
  inline int determineWidgetType( int pid, QWidget * w, QWidget * label );
  inline void connectWidget( PropertyValue & p );
  void setWidget( PropertyValue & p );
  QVariant widgetValue( PropertyValue & p );

  QHash<int, PropertyValue *> _list;
  uint _wid;
};

} // namespace QGpGuiTools

#endif // PROPERTYWIDGET_H
