/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2005-09-13
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SAMPLINGWIDGET_H
#define SAMPLINGWIDGET_H

#include <QGpCoreTools.h>

#include "ui_SamplingWidget.h"
#include "QGpGuiToolsDLLExport.h"

namespace QGpGuiTools {

class QGPGUITOOLS_EXPORT SamplingWidget : public QWidget, private Ui::SamplingWidget
{
  Q_OBJECT
public:
  SamplingWidget(QWidget* parent = 0);

  void setFileId( QString id ) { _fileId = id; }
  void setUnit( QString u ) { fromValue->setSuffix(u); toValue->setSuffix(u); }
  void setRangeOnly();
  void inversed();
  void setPrecision( int digit );
  void setSingleStep( double s );
  void setAdmissibleRange( double min, double max );
  void setInversed( bool inversed, bool inverseValues = true );
  bool isInversed() const { return _inversed; }

  int count() const {return sampCount->value();}
  void setCount(int n) {sampCount->setValue(n);}
  double minimum() const {return fromValue->value();}
  void setMinimum(double v) {return fromValue->setValue(v);}
  double maximum() const {return toValue->value();}
  void setMaximum(double v) {return toValue->setValue(v);}
  void setSampling(Sampling::Type s) {stepType->setCurrentIndex(s==Sampling::Log ? 0 : 1);}

  void getParameters( Sampling & param );
  bool loadParameters( QString keyword, QString value, QString prefix = QString::null );
  void exportParameters( QString & log, QString prefix = QString::null );
private slots:
  void on_stepType_currentIndexChanged( int index );
signals:
  void parametersChanged();
  void sampleCountChanged();
private:
  double _admissibleMin, _admissibleMax;
  bool _inversed;
  QString _fileId;
};

} // namespace QGpGuiTools

#endif // SAMPLINGWIDGET_H
