/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2007-02-23
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SMOOTHINGWIDGET_H
#define SMOOTHINGWIDGET_H

#include <QtGui>

#include <QGpCoreTools.h>

#include "ui_SmoothingWidget.h"
#include "QGpGuiToolsDLLExport.h"

namespace QGpGuiTools {

class QGPGUITOOLS_EXPORT SmoothingWidget : public QWidget, private Ui::SmoothingWidget
{
  Q_OBJECT
public:
  SmoothingWidget( QWidget * parent=0 );
  ~SmoothingWidget();

  void removeNoSmoothing() { type->removeItem(4); }
  void updateAllFields() {on_type_activated(0);}

  bool loadParameters( QString& keyword, QString& value );
  void exportParameters( QString& log );
  void getParameters( SmoothingParameters& param ) const;
private slots:
  void on_type_activated( int );
signals:
  void parametersChanged();
};

} // namespace QGpGuiTools

#endif // SMOOTHINGWIDGET_H
