/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2006-11-03
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef UPDATEICON_H
#define UPDATEICON_H

#include <QGpCoreTools.h>
#include <QtGui>

#include "QGpGuiToolsDLLExport.h"
#include "HttpAccess.h"

class QHttp;
class QHostInfo;

namespace QGpGuiTools {

class QGPGUITOOLS_EXPORT UpdateIcon : public QLabel
{
  Q_OBJECT
public:
  UpdateIcon( QWidget * parent=0 );
  ~UpdateIcon();

  enum State {Connecting, NotConnected, Connected, NewRelease};

  void setVersion(const QString& v) {_version=Version(v);}
  void setVersionType(const QString& vt) {_versionType= vt;}
  void setName(const QString& n) {_name=n;}
  void addPlugin(const QString& n);
  void addPlugins(const QStringList& nl);

private slots:
  void checkAvailability();
  void sent(bool ok);
  void showState();
  void download();
private:
  State _state;
  QString _name;
  QStringList _plugins;
  Version _version;
  QString _versionType;
  HttpAccess * _access;
};

} // namespace QGpGuiTools

#endif // UPDATEICON_H
