/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2007-11-25
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef XMLITEM_H
#define XMLITEM_H

#include <QtGui>
#include <QGpCoreTools.h>

#include "QGpGuiToolsDLLExport.h"

namespace QGpGuiTools {

class QGPGUITOOLS_EXPORT XMLItem : public QAbstractItemModel
{
public:
  XMLItem( QObject * parent=0 );
  ~XMLItem() {}

  void setText( QString xml );
  QString saveString();
  QByteArray saveByteArray();
  void saveFile(QString fileName);

  virtual int rowCount(const QModelIndex &parent = QModelIndex()) const;
  virtual int columnCount(const QModelIndex &parent = QModelIndex()) const;
  virtual QVariant data(const QModelIndex &index, int role) const;
  virtual bool setData ( const QModelIndex & index, const QVariant & value, int role );
  virtual QVariant headerData( int section, Qt::Orientation orientation, int role ) const;
  virtual QModelIndex parent ( const QModelIndex & index ) const;
  virtual QModelIndex index ( int row, int column, const QModelIndex & parent = QModelIndex() ) const;
  virtual Qt::ItemFlags flags ( const QModelIndex & index) const;

  void getSelection( QList<XMLGenericItem *>& sel, const QItemSelectionModel& sm,
                     const QModelIndex& parent = QModelIndex() );
  XMLGenericItem * xmlItem( const QModelIndex& index ) const;
  XMLGenericItem * rootItem() { return &_rootItem; }
  QModelIndex index( XMLGenericItem * o );
  void removeChildren( XMLGenericItem * o );
  void refresh( XMLGenericItem * o );
private:
  XMLGenericItem _rootItem;
};

} // namespace QGpGuiTools

#endif // XMLITEM_H
