/***************************************************************************
**
**  This file is part of QGpGuiWave.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2008-07-12
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef DISPERSIONLIMITLAYER_H
#define DISPERSIONLIMITLAYER_H

#include <QGpCoreTools.h>
#include <SciFigs.h>

#include "QGpGuiWaveDLLExport.h"

namespace QGpGuiWave {

class QGPGUIWAVE_EXPORT DispersionLimitLayer : public LineLayer
{
  Q_OBJECT
public:
  DispersionLimitLayer(AxisWindow * parent);
  ~DispersionLimitLayer();

  void setFrequencySampling(const Sampling& fparam);
  void setConstantWaveNumber(int curveIndex, double k);

  void addArrayLimits();
public slots:
  void setArrayKmin(double k);
  void setArrayKmax(double k);
private:
  Curve<Point>& curve(int index);
};

} // namespace QGpGuiWave

#endif // DISPERSIONLIMITLAYER_H
