/***************************************************************************
**
**  This file is part of QGpGuiWave.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2008-11-03
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef DISPERSIONPROXY_H
#define DISPERSIONPROXY_H

#include <QGpCoreTools.h>
#include "ModalProxy.h"
#include "QGpGuiWaveDLLExport.h"

namespace QGpGuiWave {

class QGPGUIWAVE_EXPORT DispersionProxy : public ModalProxy
{
  TRANSLATIONS("DispersionProxy")
public:
  virtual QString tag() const { return "DispersionProxy"; }

  virtual int columnCount() const {return 7;}
  virtual QString columnName( int col ) const;
  virtual QString columnUnit( int col ) const;

  virtual QVariant columnValue( int index, int sample, int col ) const;
  virtual void setColumnValue( int index, int sample, int col, const QVariant & value );

  virtual int xAxisColumn() const { return 0; }
  virtual int xAxisInversedColumn() const  { return 1; }
  virtual int yAxisColumn() const { return 2; }
  virtual int yAxisInversedColumn() const { return 3; }

  virtual QStringList columnFileTypes() const;
  virtual QVector<int> defaultColumnFileTypes() const;
  virtual QVector<int> savedColumns() const;

  virtual void parse( int index, ColumnTextIterator& it);
};

} // namespace QGpGuiWave

#endif // DISPERSIONPROXY_H
