/***************************************************************************
**
**  This file is part of QGpGuiWave.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2006-09-27
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef MODALCURVEBROWSER_H
#define MODALCURVEBROWSER_H

#include <SciFigs.h>
#include "ModeDelegate.h"
#include "ModalLine.h"
#include "QGpGuiWaveDLLExport.h"

namespace QGpGuiWave {

class ModalProxy;
class ModeSelector;

class QGPGUIWAVE_EXPORT ModalCurveBrowser : public CurveBrowser
{
  Q_OBJECT
public:
  ModalCurveBrowser( QWidget * parent=0 );
  ~ModalCurveBrowser();

  void setProxy( ModalProxy * proxy );
  void initLayer( LineLayer * curveLayer );

  void setModeFlags( ModeDelegate::Flags f );
  void setDefaultModeIndex( int i );
  void setDefaultModeRingIndex( int i );

  QList<ModalCurve> curves() const;
  void addCurve( const ModalCurve& curve );
  void addCurves( const QList<ModalCurve>& curves );

  virtual void clear();
  virtual void setEditable( bool e );
protected slots:
  virtual void on_curveScroll_valueChanged( int );
  void on_addBut_clicked();
  void on_removeBut_clicked();
private:
  ModalCurve& curve( int index ) const;

  QSplitter * msSplitter;
  ModeSelector * modes;
  bool _rayleighPhaseOnly;
};

} // namespace QGpGuiWave

#endif // MODALCURVEBROWSER_H
