/***************************************************************************
**
**  This file is part of QGpGuiWave.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2006-09-21
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef MODALLINE_H
#define MODALLINE_H

#include <SciFigs.h>
#include <QGpCoreWave.h>
#include "QGpGuiWaveDLLExport.h"

namespace QGpGuiWave {

class QGPGUIWAVE_EXPORT ModalLine : public AbstractLine
{
  TRANSLATIONS("ModalLine")
public:
  virtual AbstractLine * clone() const;
  void operator=(const ModalLine& o);

  virtual const QString& xml_tagName() const {return xmlModalLineTag;}
  static const QString xmlModalLineTag;

  virtual int count() const { return _curve.count(); }
  virtual void clear() { _curve.clear(); }
  virtual void append() { _curve.append( FactoryPoint() ); }
  virtual void insert( int index ) { _curve.insert( index, FactoryPoint() ); }
  virtual void removeLast() { _curve.remove( _curve.count()-1 ); }
  virtual bool isValid( int index ) const { return _curve[index].isValid(); }
  virtual void setValid( int index, bool v) { _curve[index].setValid(v); }
  virtual Point point( int index ) const;
  virtual void setX( int index, double v ) {_curve[index].setX(v);}
  virtual void setY( int index, double v ) {_curve[index].setMean(v);}
  virtual void setZ( int index, double v ) {_curve[index].setStddev(v);}

  const ModalCurve& curve() const { return _curve; }
  ModalCurve& curve() { return _curve; }
  void setCurve( const ModalCurve& curve ) { _curve = curve; }
protected:
  ModalCurve _curve;
};

} // namespace QGpGuiWave

#endif // MODALLINE_H
