/***************************************************************************
**
**  This file is part of QGpGuiWave.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2007-02-22
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef MODEDELEGATE_H
#define MODEDELEGATE_H

#include <QtGui>
#include <QGpCoreWave.h>
#include "QGpGuiWaveDLLExport.h"

namespace QGpGuiWave {

class QGPGUIWAVE_EXPORT ModeDelegate : public QItemDelegate
{
  Q_OBJECT
public:
  ModeDelegate( QObject *parent = 0 );

  enum Flag { Phase=1, Group=2, Rayleigh=4, Love=8, Vertical=16, Radial=32, Transverse=64 };
  Q_DECLARE_FLAGS(Flags, Flag)

  void setFlags( Flags f ) { _flags = f; }
  void setDefaultIndex( int i ) { _defaultIndex = i; }
  void setDefaultRingIndex( int i ) { _defaultRingIndex = i; }
  Mode defaultMode() const;

  QWidget *createEditor( QWidget *parent, const QStyleOptionViewItem &option,
                         const QModelIndex &index ) const;
  void setEditorData( QWidget *editor, const QModelIndex &index ) const;
  void setModelData( QWidget *editor, QAbstractItemModel *model,
                     const QModelIndex &index ) const;
private:
  Flags _flags;
  int _defaultIndex, _defaultRingIndex;
};

} // namespace QGpGuiWave

Q_DECLARE_OPERATORS_FOR_FLAGS(QGpGuiWave::ModeDelegate::Flags)

#endif // MODEDELEGATE_H
