/***************************************************************************
**
**  This file is part of QGpGuiWave.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2007-02-08
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef MODEITEM_H
#define MODEITEM_H

#include <QtGui>

#include <QGpCoreWave.h>

#include "QGpGuiWaveDLLExport.h"

namespace QGpGuiWave {

class QGPGUIWAVE_EXPORT ModeItem: public QAbstractItemModel
{
  Q_OBJECT
public:
  ModeItem( QObject * parent=0 ) : QAbstractItemModel(parent) {_curve=0;}
  ~ModeItem() {}

  void setCurve( ModalCurve * c );
  virtual int rowCount(const QModelIndex &parent = QModelIndex()) const;
  virtual int columnCount(const QModelIndex &parent = QModelIndex()) const;
  virtual QVariant data(const QModelIndex &index, int role) const;
  virtual QVariant headerData(int section, Qt::Orientation orientation, int role = Qt::DisplayRole) const;
  virtual bool setData ( const QModelIndex & index, const QVariant & value, int role = Qt::EditRole );
  virtual QModelIndex parent ( const QModelIndex & ) const {return QModelIndex(); }
  virtual QModelIndex index ( int, int column, const QModelIndex & parent = QModelIndex() ) const;
  virtual Qt::ItemFlags flags ( const QModelIndex & ) const {
    return Qt::ItemIsSelectable | Qt::ItemIsEditable | Qt::ItemIsEnabled;
  }
private:
  ModalCurve * _curve;
};

} // namespace QGpGuiWave

#endif // MODEITEM_H
