/***************************************************************************
**
**  This file is part of QGpGuiWave.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2008-11-02
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef REFRACTIONLINE_H
#define REFRACTIONLINE_H

#include <QGpCoreWave.h>
#include <SciFigs.h>

#include "QGpGuiWaveDLLExport.h"

namespace QGpGuiWave {

class QGPGUIWAVE_EXPORT RefractionLine : public AbstractLine
{
  TRANSLATIONS("RefractionLine")
public:
  void operator=(const RefractionLine& o);
  virtual AbstractLine * clone() const;

  virtual const QString& xml_tagName() const {return xmlRefractionLineTag;}
  static const QString xmlRefractionLineTag;

  virtual int count() const { return _curve.count(); }
  virtual void clear() { _curve.clear(); }
  virtual void append() { _curve.append( FactoryPoint() ); }
  virtual void insert( int index ) { _curve.insert( index, FactoryPoint() ); }
  virtual void removeLast() { _curve.remove( _curve.count()-1 ); }
  virtual bool isValid( int index ) const { return _curve[index].isValid(); }
  virtual void setValid( int index, bool v) { _curve[index].setValid(v); }
  virtual Point point( int index ) const;
  virtual void setX( int index, double v ) { _curve[index].setX(v); }
  virtual void setY( int index, double v ) { _curve[index].setMean(v); }
  virtual void setZ( int index, double v ) { _curve[index].setStddev(v); }

  const RefractionCurve& curve() const { return _curve; }
  RefractionCurve& curve() { return _curve; }
  void setCurve( const RefractionCurve& curve ) { _curve = curve; }
protected:
  RefractionCurve _curve;
};

} // namespace QGpGuiWave

#endif // REFRACTIONLINE_H
