/***************************************************************************
**
**  This file is part of QGpGuiWave.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2008-11-03
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef REFRACTIONPROXY_H
#define REFRACTIONPROXY_H

#include <SciFigs.h>
#include <QGpCoreWave.h>

#include "QGpGuiWaveDLLExport.h"

namespace QGpGuiWave {

class QGPGUIWAVE_EXPORT RefractionProxy : public CurveBrowserProxy
{
  TRANSLATIONS("RefractionProxy")
public:
  virtual QString tag() const { return "TravelTimeProxy"; }

  virtual int sampleCount( int index ) const;
  virtual void setFunction( int index );
  virtual double minimumX( int index ) const;
  virtual double maximumX( int index ) const;
  virtual double minimumY( int index ) const;
  virtual double maximumY( int index ) const;
  virtual bool isValid( int index, int sample ) const;
  virtual void setValid( int index, int sample, bool v );
  virtual void setName( int index, const QString & n );
  virtual QString name( int index ) const;
  virtual void addLog( int index, QString s );
  virtual QString log( int index ) const;
  virtual void cut( int index, double min, double max, SamplingOptions options );
  virtual void resample( int index, int n, double min, double max,
                         SamplingOptions options,
                         double valX, double valY );
  virtual void resample( int index, int n, double min, double max,
                         SamplingOptions options );
  virtual void average( int index, int indexOther );

  virtual int columnCount() const { return 4; }
  virtual QString columnName( int col ) const;
  virtual QString columnUnit( int col ) const;

  virtual QVariant columnValue( int index, int sample, int col ) const;
  virtual void setColumnValue( int index, int sample, int col, const QVariant & value );

  virtual int xAxisColumn() const { return 0; }
  virtual int xAxisInversedColumn() const  { return -1; }
  virtual int yAxisColumn() const { return 1; }
  virtual int yAxisInversedColumn() const { return -1; }
  virtual void setXAxisProperties( Axis * a );
  virtual void setYAxisProperties( Axis * a );

  virtual QStringList columnFileTypes() const;
  virtual QVector<int> defaultColumnFileTypes() const;
  virtual QVector<int> savedColumns() const;

  virtual void parse( int index, ColumnTextIterator& it);
protected:
  const RefractionCurve& curve( int index ) const;
  RefractionCurve& curve( int index );
};

} // namespace QGpGuiWave

#endif // REFRACTIONPROXY_H
