/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2008-07-17
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ACTIVITYMONITOR_H
#define ACTIVITYMONITOR_H

#include "AxisWindow.h"
#include "SciFigsDLLExport.h"

namespace SciFigs {

class LineLayer;

class SCIFIGS_EXPORT ActivityMonitor : public AxisWindow
{
  Q_OBJECT
public:
  ActivityMonitor(QWidget *parent=0, Qt::WFlags f=0);
  ~ActivityMonitor();

  void setDisplayRange( double t );
  void setMeasurementDelay( double d );
  void hit() { _hits++; }

  QSize sizeHint () const { return QSize( 100, 25 ); }
  QSize minimumSizeHint () const { return QSize( 50, 25 ); }
protected:
  virtual void mousePressEvent ( QMouseEvent * e );
  virtual void mouseReleaseEvent ( QMouseEvent * e );
  virtual void mouseDoubleClickEvent ( QMouseEvent * e );
private slots:
  void measure();
private:
  QTimer _measurementTimer;
  int _hits;
  LineLayer * _layer;
};

} // namespace SciFigs

#endif // ACTIVITYMONITOR_H
