/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2008-03-28
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef AXISFORMATPROPERTIES_H
#define AXISFORMATPROPERTIES_H

#include <QGpGuiTools.h>

#include "ui_AxisFormatProperties.h"
#include "Axis.h"

namespace SciFigs {

class AxisFormatProperties : public PropertyWidget, private Ui::AxisFormatProperties
{
  Q_OBJECT
public:
  AxisFormatProperties( QWidget * parent=0 );

  enum Properties { Title, Font, Orientation, LineWeight, TickSize,
                    NumberType, NumberPrecision, Autoprecision, UnitFactor };

  static int numberType2item( Number::Type nt );
  static Number::Type item2numberType(int index);

  static int orientation2item( Axis::Orientation o );
  static Axis::Orientation item2orientation(int index);
private:
  virtual int determineCustomWidgetType( int pid, QWidget * w, QWidget * label );
  virtual bool connectCustomWidget( PropertyValue & );
  virtual bool setCustomWidget( PropertyValue & p );
  virtual QVariant customWidgetValue( PropertyValue & p );
signals:
  void numberFormatChanged();
private slots:
  void on_numberTypeEdit_activated(int);
  void on_precisionEdit_valueChanged(int);
  void on_automaticPrecision_toggled(bool b);
  void on_fontEdit_clicked();
};

} // namespace SciFigs

#endif // AXISFORMATPROPERTIES_H
