/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2005-07-04
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef AXISPROPERTIES_H
#define AXISPROPERTIES_H

#if 0
#include "ui_AxisProperties.h"
#include "PropertyWidget.h"
#include "Dialog.h"
#include "Settings.h"

namespace SciFigs {

class AxisProperties : public Dialog, public Ui::AxisProperties, public PropertyValues
{
  Q_OBJECT
public:
  AxisProperties(QWidget * parent);
  ~AxisProperties() {}

  void setValues( QList<Axis *> aList );
  void checkValues( Axis * a );
  int checkMinMaxForScale();

  int numberPrecisionInversedScale() {return _numberPrecisionInversedScale;}
  double unitFactor();
  QString titleInversedScale();
  QFont titleFont() {return title->font();}

private slots:
  void setScaled();
  void setAxisLength();
  void setTotalLength();
  void changeNumFormat();
  void setAutoTicks();
  void updateAutoTicks();
  void on_minZoom_clicked();
  void on_maxZoom_clicked();
  void on_minContent_clicked();
  void on_maxContent_clicked();
  void on_fontBut_clicked();
  void on_automaticPrecision_toggled(bool);
  void changeScale();
private:
  void setScaleType( bool normalScale, bool inversedScale, bool logScale );
  void setNumberType( bool fixed , bool scientific, bool time );
  char _numberType;
  int _numberPrecisionInversedScale;
  QString _titleInversedScale;
  Scale _scale;
  double _minContentValue, _maxContentValue;
};
#endif

#endif // AXISPROPERTIES_H
