/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2010-02-21
**  Authors:

**
***************************************************************************/

#ifndef CIRCLEMASK_H
#define CIRCLEMASK_H

#include "CircleViewer.h"

namespace SciFigs {

  class SCIFIGS_EXPORT CircleMask : public CircleViewer
  {
  public:
    CircleMask(AxisWindow * parent=0);

    virtual const QString& xml_tagName() const {return xmlCircleMaskTag;}
    static const QString xmlCircleMaskTag;

    virtual void paintData(const LayerPainterRequest& lp, QPainter& p, double dotpercm) const;
    virtual Rect boundingRect() const;

    void setCircle(double x, double y, double rx, double ry, QColor col);
  protected:
    void xml_polich(XML_POLISH_ARGS);
  };

} // namespace SciFigs

#endif // CIRCLEMASK_H
