/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2003-10-16
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef CIRCLEVIEWER_H
#define CIRCLEVIEWER_H

#include "GraphContentLayer.h"

namespace SciFigs {

  class SCIFIGS_EXPORT CircleViewer :  public GraphContentLayer
  {
    Q_OBJECT
    Q_PROPERTY( double lineWeight READ lineWeight WRITE setLineWeight SCRIPTABLE true )
  public:
    CircleViewer(AxisWindow * parent = 0);

    virtual const QString& xml_tagName() const {return xmlCircleViewerTag;}
    static const QString xmlCircleViewerTag;

    void resize(int n);
    void clear();

    double lineWeight() const {return _lineWeight;}
    void setLineWeight (double lw);

    virtual void paintData( const LayerPainterRequest& lp, QPainter& p, double dotpercm ) const;
    virtual Rect boundingRect() const ;
  public slots:
    Q_SCRIPTABLE void setCircle(int index, double x, double y, double rx, double ry, QColor col);
    Q_SCRIPTABLE void addCircle(double x, double y, double rx, double ry, QColor col);
    Q_SCRIPTABLE void insertCircle(int index, double x, double y, double rx, double ry, QColor col);
    Q_SCRIPTABLE void removeCircle(int index);
  protected:
    QVector<double> _x;
    QVector<double> _y;
    QVector<double> _rx;
    QVector<double> _ry;
    QVector<QColor> _col;
    double _lineWeight; // Line weight in cm

    class SCIFIGS_EXPORT Limits
    {
    public:
      Limits(const GraphContentOptions& gc);

      bool polarLimits( double x, double y, double r, double& startphi, double& stopphi ) const;
    private:
      // The four corners of the visible area
      Point2D _a,_b,_c,_d;
      // The four segments of the visible area
      Segment2D _ab,_bc,_cd,_da;
      // The rect
      Rect _visLimits;
    };
  protected:
    void xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const;
    XMLMember xml_member(XML_MEMBER_ARGS);
    bool xml_setProperty(XML_SETPROPERTY_ARGS);
  };

} // namespace SciFigs

#endif // CIRCLEVIEWER_H
