/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2008-03-26
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef COLORPALETTELAYER_H
#define COLORPALETTELAYER_H

#include "GraphContentLayer.h"
#include "SciFigsDLLExport.h"

namespace SciFigs {

class SCIFIGS_EXPORT ColorPaletteLayer : public GraphContentLayer
{
  Q_OBJECT
  Q_PROPERTY( QString axisType READ axisTypeString WRITE setAxisType SCRIPTABLE true )
public:
  ColorPaletteLayer(AxisWindow * parent=0);

  virtual const QString& xml_tagName() const {return xmlColorPaletteLayerTag;}
  static const QString xmlColorPaletteLayerTag;

  enum AxisType {AxisX,AxisY};

  void setAxisType(AxisType a);
  AxisType axisType() const {return _axisType;}
  QString axisTypeString() const {return _axisType==AxisX ? "X":"Y";}
  void setAxisType(QString t) { if (t.contains("X")) setAxisType(AxisX); else setAxisType(AxisY);}

  const ColorPalette& palette() const {return _pal;}
  void setPalette( const ColorPalette& pal ) {_pal=pal;}

  virtual Rect boundingRect() const;
protected:
  virtual void paintData(const LayerPainterRequest& lp, QPainter& p, double dotpercm) const;
  virtual QString coordinateTipInfo(const Point2D& p) const;
private:
  static inline void paintX(double min, double max, double w, double h, const QColor& col,
                            const GraphContentOptions& gc, QPainter& p);
  static inline void paintY(double min, double max, double w, double h, const QColor& col,
                            const GraphContentOptions& gc, QPainter& p);

  AxisType _axisType;
  ColorPalette _pal;
};

} // namespace SciFigs

#endif // COLORPALETTELAYER_H
