/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2003-05-07
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef COLORPALETTEWIDGET_H
#define COLORPALETTEWIDGET_H

#include "GraphicObject.h"
#include "Axis.h"

namespace SciFigs {

class PaletteProperties;
class PaletteEditor;
class ColorPaletteLayer;

class SCIFIGS_EXPORT ColorPaletteWidget : public GraphicObject
{
  Q_OBJECT
  // Compatibility
  Q_PROPERTY( QString numType READ dummyPropertyString WRITE setNumberType STORED false )
  Q_PROPERTY( int numPrec READ dummyPropertyInt WRITE setNumberPrecision STORED false )
  Q_PROPERTY( QString title READ dummyPropertyString WRITE setTitle STORED false )
  Q_PROPERTY( QString numberType READ dummyPropertyString WRITE setNumberType STORED false )
  Q_PROPERTY( int numberPrecision READ dummyPropertyInt WRITE setNumberPrecision STORED false )
  Q_PROPERTY( QString font READ dummyPropertyString WRITE setFontString STORED false )
  Q_PROPERTY( double lineWeight READ dummyPropertyDouble WRITE setLineWeight STORED false )
  Q_PROPERTY( double tickLength READ dummyPropertyDouble WRITE setTickSize STORED false )
  Q_PROPERTY( double tickLenght READ dummyPropertyDouble WRITE setTickSize STORED false )
public:
  ColorPaletteWidget(QWidget *parent=0, Qt::WFlags f = 0);
  ~ColorPaletteWidget();

  ColorPaletteWidget& operator=(const ColorPaletteWidget& o);

  virtual const QString& xml_tagName() const {return xmlColorPaletteWidgetTag;}
  static const QString xmlColorPaletteWidgetTag;

  void setAxis( const Axis& a );
  const Axis& axis() const;

  const ColorPalette& palette() const;

  void setOrientation( Axis::Orientation o ) { axis().setOrientation( o ); }
  Axis::Orientation orientation() const { return axis().orientation(); }

  virtual int* scaleFonts( double factor );
  virtual void restoreScaleFonts( int* tmp );

  virtual void addProperties( PropertyProxy * pp );
  virtual void removeProperties( PropertyProxy * pp );
  virtual void properties( PropertyWidget * w ) const;
  virtual void setProperty( uint wid, int pid, QVariant val );
public slots:
  virtual Q_SCRIPTABLE void update();
  virtual Q_SCRIPTABLE void deepUpdate();
  Q_SCRIPTABLE void setNumColor(int n);
  Q_SCRIPTABLE void defaultColors(int n);
  Q_SCRIPTABLE void defaultBW(int n);
  Q_SCRIPTABLE void defaultHSVColors(int sat, int value, int n=10, int transparency=255);
  Q_SCRIPTABLE void colorInterpole(int imin, int imax);
  Q_SCRIPTABLE void setVLinear(double min, double max);
  Q_SCRIPTABLE void setVLog(double min, double max);
  Q_SCRIPTABLE void load(QString fileName);
  Q_SCRIPTABLE void save(QString fileName);
  void setPalette( const ColorPalette& pal );

  void setScaleType( Scale::Type t ) { axis().setScaleType( t ); }
  void setNumberType( QString t ) { axis().setNumberType( Number::type(t.toAscii().data()[0]) ); }
  void setNumberPrecision( int p ) { axis().setCurrentNumberPrecision(p);}
  void setTitle( QString s ) { axis().setCurrentTitle(s);}
  void setFontString( QString fs ) { axis().setFontString( fs ); }
  void setLineWeight( double val ) { axis().setLineWeight( val ); }
  void setTickSize( double val ) { axis().setTickSize( val ); }
protected:
  virtual bool eventFilter( QObject * obj, QEvent * e);
  virtual void resizeEvent( QResizeEvent * );
private slots:
  void setOrientation();
signals:
  void changed( ColorPalette pal );
protected:
  virtual void print( QPainter& p, double dotpercm, int x0Sheet, int y0Sheet, bool mask );
  XMLMember xml_member(XML_MEMBER_ARGS);
  void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
  void xml_polishChild(XML_POLISHCHILD_ARGS);
private:
  Axis& axis();
  QMouseEvent * convertMouseEvent( QObject * obj, QEvent * e );

  ColorPaletteLayer * _paletteLayer;
  static uint _category, _tabPalette;
};

} // namespace SciFigs

#endif // COLORPALETTEWIDGET_H
