/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2008-10-31
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef CURVEBROWSER_H
#define CURVEBROWSER_H

#include <QGpGuiTools.h>

#include "ui_CurveBrowser.h"
#include "SciFigsDLLExport.h"

namespace SciFigs {

class LineLayer;
class CurveBrowserProxy;
class AxisWindow;
class AbstractLine;
class LegendProperties;

class SCIFIGS_EXPORT CurveBrowser : public QWidget, protected Ui::CurveBrowser
{
  Q_OBJECT
public:
  CurveBrowser( QWidget * parent = 0 );
  ~CurveBrowser();

  void setProxy( CurveBrowserProxy * proxy );
  CurveBrowserProxy * proxy() { return _proxy; }
  void dock( QWidget * w );

  QAction * addCurveAction( QString title, QString toolTip, bool editCurve );
  virtual void setEditable( bool e );

  void initLayer(LineLayer * curveLayer);
  void setCurrentLayer(LineLayer * curveLayer);
  LineLayer * currentLayer() const {return _currentLayer;}

  int count() const;
  int currentLine() const;
  void loadMultiColumns( QString fileName, bool lastFile, ColumnTextParser *& parser );
public slots:
  virtual void load();
  void save();
  void clear();
  void legend();
  void average();
  void showLog();
  void remove();
  void resample();
  void cut();
  void smooth();
  void curvesChanged();
  virtual void setLimits();
protected slots:
  virtual void on_curveScroll_valueChanged( int );
private slots:
  void on_loadBut_clicked() { load(); }
  void on_legendBut_clicked() { legend(); }
  void on_clearBut_clicked();
  void on_visibleBut_toggled( bool checked );
  void on_curveName_textChanged( const QString & );
  void applyAllSelected();
  void newPickedLine( AbstractLine * line );
  void newPickedPoint( AbstractLine *, int );
  void commitLegend();
signals:
  void curveModified();
protected:
  void closeEvent(QCloseEvent * e);
  virtual void loadMultiColumns(const ColumnTextParser * parser, QString fileName);
private:
  LineLayer * _currentLayer;
  int _currentCurve;
  CurveBrowserProxy * _proxy;
  LegendProperties * _legendEditor;
  bool _editable;
};

} // namespace SciFigs

#endif // CURVEBROWSER_H
