/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2007-02-06
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef CURVEBROWSERITEM_H
#define CURVEBROWSERITEM_H

#include <QtGui>
#include "SciFigsDLLExport.h"

namespace SciFigs {

class CurveBrowserProxy;

class SCIFIGS_EXPORT CurveBrowserItem : public QAbstractItemModel
{
  Q_OBJECT
public:
  CurveBrowserItem( CurveBrowserProxy * proxy, QObject * parent = 0 );
  ~CurveBrowserItem() {}

  void setCurrentLine( int index );
  void setEditable( bool e ) { _editable = e; }
  virtual int rowCount(const QModelIndex &parent = QModelIndex()) const;
  virtual int columnCount(const QModelIndex &parent = QModelIndex()) const;
  virtual QVariant data(const QModelIndex &index, int role) const;
  virtual QVariant headerData(int section, Qt::Orientation orientation, int role = Qt::DisplayRole) const;
  virtual bool setData ( const QModelIndex & index, const QVariant & value, int role = Qt::EditRole );
  virtual QModelIndex parent ( const QModelIndex & ) const {return QModelIndex(); }
  virtual QModelIndex index ( int, int column, const QModelIndex & parent = QModelIndex() ) const;
  virtual Qt::ItemFlags flags ( const QModelIndex & ) const;
private:
  CurveBrowserProxy * _proxy;
  int _currentLine;
  bool _editable;
};

} // namespace SciFigs

#endif // CURVEBROWSERITEM_H
