/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2008-11-03
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef CURVEBROWSERPROXY_H
#define CURVEBROWSERPROXY_H

#include <QGpCoreTools.h>

#include "SciFigsDLLExport.h"

namespace SciFigs {

class Axis;
class LineLayer;

class SCIFIGS_EXPORT CurveBrowserProxy
{
  TRANSLATIONS("CurveBrowserProxy")
public:
  CurveBrowserProxy() {}
  virtual ~CurveBrowserProxy() {}

  virtual QString tag() const = 0;

  void setCurrentLayer( LineLayer * curveLayer ) { _currentLayer = curveLayer; }
  LineLayer * currentLayer() const { return _currentLayer; }

  virtual void clear() {}
  virtual void removeLine( int /*index*/ ) {}

  virtual int sampleCount( int index ) const = 0;
  virtual void setFunction( int index ) = 0;
  virtual double minimumX( int index ) const = 0;
  virtual double maximumX( int index ) const = 0;
  virtual double minimumY( int index ) const = 0;
  virtual double maximumY( int index ) const = 0;
  virtual bool isValid( int index, int sample ) const = 0;
  virtual void setValid( int index, int sample, bool v ) = 0;
  virtual void setName( int index, const QString & n ) = 0;
  virtual QString name( int index ) const;
  int indexOf( const QString & n );
  virtual void addLog( int index, QString s ) = 0;
  virtual QString log( int index ) const = 0;
  virtual void cut( int index, double min, double max, SamplingOptions options ) = 0;
  virtual void resample( int index, int n, double min, double max, SamplingOptions options, double valX, double valY ) = 0;
  virtual void resample( int index, int n, double min, double max, SamplingOptions options ) = 0;
  virtual void average( int index, int indexOther ) = 0;

  virtual QVariant columnValue( int index, int sample, int col ) const = 0;
  virtual void setColumnValue( int index, int sample, int col, const QVariant & value ) = 0;

  virtual int columnCount() const = 0;
  virtual QString columnName( int col ) const = 0;
  virtual QString columnUnit( int col ) const = 0;
  QString columnTitle( int col ) const;

  virtual int xAxisColumn() const = 0;
  virtual int xAxisInversedColumn() const = 0;
  virtual int yAxisColumn() const = 0;
  virtual int yAxisInversedColumn() const = 0;
  virtual void setXAxisProperties( Axis * a );
  virtual void setYAxisProperties( Axis * a );

  virtual QStringList columnFileTypes() const = 0;
  virtual QVector<int> defaultColumnFileTypes() const = 0;
  virtual QVector<int> savedColumns() const = 0;

  void save( int index, QTextStream& s );
  virtual void parse(int index, ColumnTextIterator& it)=0;

  QString xName() const { return columnName(xAxisColumn()); }
  QString xUnit() const { return columnUnit(xAxisColumn()); }
  QString xTitle() const { return columnTitle(xAxisColumn()); }
  QString xInversedName() const { return columnName(xAxisInversedColumn()); }
  QString xInversedUnit() const { return columnUnit(xAxisInversedColumn()); }
  QString xInversedTitle() const { return columnTitle(xAxisInversedColumn()); }
  QString yName() const { return columnName(yAxisColumn()); }
  QString yUnit() const { return columnUnit(yAxisColumn()); }
  QString yTitle() const { return columnTitle(yAxisColumn()); }
  QString yInversedName() const { return columnName(yAxisInversedColumn()); }
  QString yInversedUnit() const { return columnUnit(yAxisInversedColumn()); }
  QString yInversedTitle() const { return columnTitle(yAxisInversedColumn()); }
protected:
  LineLayer * _currentLayer;
};

} // namespace SciFigs

#endif // CURVEBROWSERPROXY_H
