/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2008-11-03
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef GRAPHCONTENTLAYERFACTORY_H
#define GRAPHCONTENTLAYERFACTORY_H

#include <QGpCoreTools.h>

#include "SciFigsDLLExport.h"

namespace SciFigs {

#define REGISTER_GRAPHCONTENTLAYER( _className_, _tagName_ ) \
  XMLREGISTER_HEAD( "Layer", XMLClassCreator, _className_, _tagName_) \
  XMLREGISTER_TAIL( _className_)

#define SYNONYM_GRAPHCONTENTLAYER( _synName_, _tagName_ ) \
  XMLSYNONYM( "Layer", _synName_, _tagName_ )

class SCIFIGS_EXPORT GraphContentLayerFactory : public XMLClassFactory
{
public:
  XMLClass * create( QString tag ) {
    return XMLClassFactory::create("Layer", tag );
  }
  static GraphContentLayerFactory * instance() {
    return reinterpret_cast<GraphContentLayerFactory *>(& _self);
  }
};

} // namespace SciFigs

#endif // GRAPHCONTENTLAYERFACTORY_H
