/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2008-04-02
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef GRAPHCONTENTLAYERPROPERTIES_H
#define GRAPHCONTENTLAYERPROPERTIES_H

#include "ui_GraphContentLayerProperties.h"
#include "GraphContent.h"

namespace SciFigs {

class LayerPropertiesItem : public QAbstractItemModel
{
  Q_OBJECT
public:
  LayerPropertiesItem( QObject * parent=0 ) : QAbstractItemModel( parent ) { _graph = 0; }

  void setGraph( GraphContent * g );

  virtual int rowCount(const QModelIndex &parent = QModelIndex()) const;
  virtual int columnCount(const QModelIndex &parent = QModelIndex()) const;
  virtual QVariant data(const QModelIndex &index, int role) const;
  virtual QVariant headerData(int section, Qt::Orientation orientation, int role = Qt::DisplayRole) const;
  virtual QModelIndex parent ( const QModelIndex & ) const { return QModelIndex(); }
  virtual QModelIndex index ( int, int column, const QModelIndex & parent = QModelIndex() ) const;
  virtual bool setData ( const QModelIndex & index, const QVariant & value, int role = Qt::EditRole );
  virtual Qt::ItemFlags flags ( const QModelIndex & ) const;

  int removeLayers( QModelIndexList l );
  void moveLayersUp( QModelIndexList l );
  void moveLayersDown( QModelIndexList l );
  void selectLayers( QModelIndexList l );
  void selectAllLayers( bool s );
private:
  GraphContent * _graph;
};

class LayerPropertiesDelegate : public QItemDelegate
{
  Q_OBJECT
public:
  LayerPropertiesDelegate( QObject *parent = 0 ) : QItemDelegate(parent) {}

  QWidget * createEditor( QWidget * parent, const QStyleOptionViewItem & option, const QModelIndex &index ) const;
  void setEditorData( QWidget *editor, const QModelIndex &index ) const;
  void setModelData( QWidget *editor, QAbstractItemModel *model, const QModelIndex &index ) const;
private slots:
  void commitWidgetData();
};

class GraphContentLayerProperties : public PropertyWidget, private Ui::GraphContentLayerProperties
{
  Q_OBJECT
public:
  GraphContentLayerProperties( QWidget * parent=0 );
  ~GraphContentLayerProperties();

  void addGraph( GraphContent * g );
  void removeGraph( GraphContent * g );
  void reset();
private slots:
  void on_currentGraphCombo_currentIndexChanged(int);
  void on_saveLayers_clicked();
  void on_addLayers_clicked();
  void on_removeLayers_clicked();
  void on_moveLayerUp_clicked();
  void on_moveLayerDown_clicked();
private:
  static bool graphLessThan( const GraphContent * l1, const GraphContent * l2);
  void setGraphList();
  GraphContent * currentGraph() const;

  QSet<GraphContent *> _graphSet;
  QList<GraphContent *> _graphList;
};

} // namespace SciFigs

#endif // GRAPHCONTENTLAYERPROPERTIES_H
