/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2008-11-03
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef GRAPHICOBJECTFACTORY_H
#define GRAPHICOBJECTFACTORY_H

#include <QGpCoreTools.h>

#include "SciFigsDLLExport.h"

namespace SciFigs {

#define REGISTER_GRAPHICOBJECT( _className_, _tagName_, \
                                    _userName_, _menuTitle_, \
                                    _shortcut_, _toolTip_ ) \
  XMLREGISTER_HEAD( "GraphicObject", GraphicObjectCreator, _className_, _tagName_) \
    virtual QString userName() const  { return _userName_; } \
    virtual QString menuTitle() const { return _menuTitle_; } \
    virtual QString shortcut() const { return _shortcut_; } \
    virtual QString toolTip() const { return _toolTip_; } \
    virtual QIcon icon() const { return QIcon(":/images/" # _className_ ".png"); } \
  XMLREGISTER_TAIL( _className_)

class GraphicObjectFactory;

class SCIFIGS_EXPORT GraphicObjectCreator : public XMLClassCreator
{
public:
  inline GraphicObjectCreator( QString factory, QString tag );

  virtual QString userName() const = 0;
  virtual QString menuTitle() const = 0;
  virtual QString shortcut() const = 0;
  virtual QString toolTip() const = 0;
  virtual QIcon icon() const = 0;
};

class SCIFIGS_EXPORT GraphicObjectFactory : public XMLClassFactory
{
public:
  XMLClass * create( QString tag ) {
    return XMLClassFactory::create("GraphicObject", tag );
  }
  QStringList registeredTags() const {
    return XMLClassFactory::registeredTags("GraphicObject");
  }
  inline GraphicObjectCreator * creator( QString tag );
  static GraphicObjectFactory * instance() {
    return reinterpret_cast<GraphicObjectFactory *>(& _self);
  }
};

inline GraphicObjectCreator::GraphicObjectCreator( QString factory, QString tag )
    : XMLClassCreator( factory, tag )
{
}

inline GraphicObjectCreator * GraphicObjectFactory::creator( QString tag )
{
  return static_cast<GraphicObjectCreator *>( XMLClassFactory::creator("GraphicObject", tag) );
}

} // namespace SciFigs

#endif // GRAPHICOBJECTFACTORY_H
