/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2008-03-31
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef GRAPHICOBJECTGEOMETRYPROPERTIES_H
#define GRAPHICOBJECTGEOMETRYPROPERTIES_H

#include "ui_GraphicObjectGeometryProperties.h"
#include "GraphicObject.h"

namespace SciFigs {

class GraphicObjectGeometryProperties : public PropertyWidget, private Ui::GraphicObjectGeometryProperties
{
  Q_OBJECT
public:
  GraphicObjectGeometryProperties( QWidget * parent=0 );

  enum Properties {X, Y, Anchor, Width, Height, ConstantWidthHeightRatio, WidthHeightRatio };

  static int anchor2item( GraphicObject::PositionAnchor pa );
  static GraphicObject::PositionAnchor item2anchor(int index);
};

} // namespace SciFigs

#endif // GRAPHICOBJECTGEOMETRYPROPERTIES_H
