/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2003-02-27
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef GRIDVIEWER_H
#define GRIDVIEWER_H

#include <QGpGuiTools.h>

#include "GridPlot.h"

namespace SciFigs {

class SCIFIGS_EXPORT GridViewer :  public GridPlot
{
  Q_OBJECT
public:
  GridViewer(AxisWindow * parent=0);
  ~GridViewer();

  virtual const QString& xml_tagName() const {return xmlGridViewerTag;}
  static const QString xmlGridViewerTag;

  virtual bool mouseReleaseEvent ( QMouseEvent * e, int );
  virtual bool trackRectangle( int, double rx1,double ry1, double rx2, double ry2,
                               Qt::KeyboardModifiers m);
  virtual Rect boundingRect() const;
signals:
  void clicked(int ix, int iy);
protected:
  virtual void paintData( const LayerPainterRequest& lp, QPainter& p, double dotpercm ) const;
  virtual void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
  virtual XMLMember xml_member(XML_MEMBER_ARGS);
protected:
  Grid2D<double> * _theGrid;
};

} // namespace SciFigs

#endif // GRIDVIEWER_H
