/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2006-01-10
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef IMAGELAYERPROPERTIES_H
#define IMAGELAYERPROPERTIES_H

#include <QGpGuiTools.h>
#include "ui_ImageLayerProperties.h"

namespace SciFigs {

class ImageLayer;
class ImageScalingPoint;

class ImageLayerProperties : public PropertyWidget, public Ui::ImageLayerProperties
{
  Q_OBJECT
public:
  ImageLayerProperties(QWidget * parent=0);

  void addLayer(ImageLayer * layer);
  void removeLayer(ImageLayer * layer);

  enum Properties {XOrigin, YOrigin, XScale, YScale, ImageFile};
private slots:
  void on_imageBrowse_clicked();
  void on_referenceButton_clicked();
  void setScaling();
  void referencePointClosed();
private:
  void toggleReferencePoints();

  QSet<ImageLayer *> _layerSet;
  ImageScalingPoint * _referencePoints;
};

} // namespace SciFigs

#endif // IMAGELAYERPROPERTIES_H
