/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2008-02-27
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef IRREGULARGRID2DDRAW_H
#define IRREGULARGRID2DDRAW_H

#include <QGpCoreTools.h>

namespace SciFigs {

class GraphContentOptions;

class IrregularGrid2DDraw
{
public:
  IrregularGrid2DDraw() {limx=0;limy=0;nodex=0;nodey=0;}
  ~IrregularGrid2DDraw() {delete [] limx; delete [] limy;delete [] nodex; delete [] nodey;}

  void setVisibleArea(  const IrregularGrid2D & grid, const GraphContentOptions& gc );
  void setCellNodes(  const IrregularGrid2D & grid, const GraphContentOptions& gc );
  void setCellLimits();

  int startix, stopix;
  int startiy, stopiy;
  int nx, ny;
  int * nodex, * nodey;
  int * limx, * limy;
};

} // namespace SciFigs

#endif // IRREGULARGRID2DDRAW.H
