/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2003-01-14
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef IRREGULARGRID2DPLOT_H
#define IRREGULARGRID2DPLOT_H

#include <QGpGuiTools.h>

#include "GridPlot.h"

namespace SciFigs {

class SCIFIGS_EXPORT IrregularGrid2DPlot : public GridPlot
{
  Q_OBJECT
public:
  IrregularGrid2DPlot( AxisWindow * parent = 0 );
  ~IrregularGrid2DPlot();

  virtual const QString& xml_tagName() const {return xmlIrregularGrid2DPlotTag;}
  static const QString xmlIrregularGrid2DPlotTag;

  virtual bool mouseReleaseEvent ( QMouseEvent * e, int );
  virtual bool trackRectangle( int, double rx1, double ry1, double rx2, double ry2,
                               Qt::KeyboardModifiers eventState );

  const IrregularGrid2D& grid() const { return _grid;}
  void setGrid( const IrregularGrid2D& grid );

  void setLinearPalette();
  void setLinearPalette( double minimum );
  void setLinearPalette( double minimum, double maximum ) { GridPlot::setLinearPalette( minimum, maximum ); }

  virtual Rect boundingRect() const;
  virtual QString coordinateTipInfo( const Point2D& p ) const;
private slots:
  void exportValues( QString fileName = QString::null );
signals:
  void clicked( int ix, int iy );
protected:
  virtual void paintData( const LayerPainterRequest& lp, QPainter& p, double dotpercm ) const;

  IrregularGrid2D _grid;
private:
  void addActions();

  virtual void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
  virtual XMLMember xml_member(XML_MEMBER_ARGS);
};

} // namespace SciFigs

#endif // IRREGULARGRID2DPLOT.H
