/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2008-02-14
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef LAYERPAINTERREQUEST_H
#define LAYERPAINTERREQUEST_H

#include <QtGui>

#include "GraphContent.h"

namespace SciFigs {

class LayerPainterRequest: public QObject
{
  Q_OBJECT
public:
  LayerPainterRequest();

  void setGraphContent( GraphContent * gc ) { _gc = gc; }
  GraphContent * graphContent() const { return _gc; }
  void setLayers( const QList<GraphContentLayer *>& layers ) { _layers = layers; }

  void setSize( int w, int h ) { _size = QSize(w, h); }
  void setSize( const QSize& s ) { _size = s; }
  QSize size() const { return _size; }

  void setOptions( const QSharedDataPointer<GraphContentOptions> & o ) { _options = o; }
  const GraphContentOptions& options() const { return *_options; }

  void setLayerImages( const LayerImages& li ) { _layerImages = li; }
  const LayerImages& layerImages() const { return _layerImages; }

  void setDepth( int depth );
  int depth() const { return _depth; }

  void paint();
  void paintText();
  void terminate() { _terminate.fetchAndStoreOrdered(true); }
  bool terminated() const { return _terminate.testAndSetOrdered(true, true); }
signals:
  void finished( QImage im, LayerImages li);
private:
  inline void paintLayers( QPainter& p );
  inline void paintLayers( int fromIndex, QPainter& p );

  mutable QAtomicInt _terminate;
  QImage _image;
  QSize _size;
  GraphContent * _gc;
  QList<GraphContentLayer *> _layers;
  QSharedDataPointer<GraphContentOptions> _options;
  LayerImages _layerImages;
  int _depth;
};

} // namespace SciFigs

#endif // LAYERPAINTERREQUEST_H
