/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2008-02-12
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef LAYERPAINTERTHREAD_H
#define LAYERPAINTERTHREAD_H

#include "LayerPainterRequest.h"

namespace SciFigs {

class LayerPainter;

class LayerPainterThread: public Thread
{
public:
  LayerPainterThread( LayerPainter * parent );

  LayerPainterRequest * currentRequest() const { return _currentRequest; }
  void terminate();
protected:
  virtual void run();
private:
  LayerPainter * _parent;
  QAtomicInt _terminate;
  int _terminateRequest;
  LayerPainterRequest * _currentRequest;
};

} // namespace SciFigs

#endif // LAYERPAINTERTHREAD_H
