/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2002-05-24
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef LEGEND_H
#define LEGEND_H

#include "LegendItem.h"
#include "SciFigsDLLExport.h"

namespace SciFigs {

class Pen;
class Symbol;

class SCIFIGS_EXPORT Legend : public XMLClass
{
public:
  Legend() { _textLookup = 0; }
  Legend( const Legend& o ) : XMLClass() { _textLookup = 0; operator=(o); }
  Legend( int n ) { _textLookup = 0; resize( n ); }
  virtual ~Legend() { delete _textLookup; }

  Legend& operator=( const Legend& o );
  bool operator==(const Legend& o);
  bool operator!=(const Legend& o) {return !operator==(o);}

  virtual const QString& xml_tagName() const { return xmlLegendTag;}
  static const QString xmlLegendTag;

  void resize(int n) {_items.resize(n);}
  void clear() {_items.clear();}
  void setTexts(const QStringList& texts, const Pen& defaultPen, const Symbol& defaultSymbol);

  void defaultColors( int n = 10 );
  void defaultBW( int n = 10 );
  void colorRGBInterpole( int imin, int imax );
  void colorHSVInterpole( int imin, int imax );
  const LegendItem& item( int i );

  int count() const { return _items.size(); }
  int indexOf( const QString& text ) const;

  void setText( int i, QString t );
  const QString& text( int i ) const;

  void setTextColor( int i, QColor c );
  const QColor& textColor( int i ) const;

  void setPen( int i, Pen p );
  const Pen& pen( int i ) const;
  const Pen& pen( const QString& text ) const;

  void setSymbol( int i, Symbol s );
  const Symbol& symbol( int i ) const;
  const Symbol& symbol( const QString& text ) const;

  QStringList texts() const;
  void setTexts( const Legend& o );
  void setTextColors( const Legend& o );
  void setPens( const Legend& o );
  void setSymbols( const Legend& o );

  void penColorToSymbolPen();
  void penColorToSymbolBrush();
  void penColorToText();
protected:
  virtual void xml_writeChildren( XML_WRITECHILDREN_ARGS ) const;
  virtual XMLMember xml_member( XML_MEMBER_ARGS );
protected:
  QVector<LegendItem> _items;
  mutable QMap<QString, int> * _textLookup;
};

//QTextStream& operator>>( QTextStream& s, Legend& p );

} // namespace SciFigs

// Allow passing Legend as a QVariant
using namespace SciFigs;
Q_DECLARE_METATYPE(Legend);

#endif // LEGEND_H
