/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2007-04-27
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef LEGENDFORMATPROPERTIES_H
#define LEGENDFORMATPROPERTIES_H

#include <QGpGuiTools.h>
#include "ui_LegendFormatProperties.h"

namespace SciFigs {

class LegendWidget;

class LegendFormatProperties : public PropertyWidget, private Ui::LegendFormatProperties
{
  Q_OBJECT
public:
  LegendFormatProperties( QWidget * parent=0 );

  enum Properties { Title, Font, LineSize, AdjustBox };
private:
  virtual int determineCustomWidgetType( int pid, QWidget * w, QWidget * label );
  virtual bool connectCustomWidget( PropertyValue & );
  virtual bool setCustomWidget( PropertyValue & p );
  virtual QVariant customWidgetValue( PropertyValue & p );
private slots:
  void on_fontBut_clicked();
};


} // namespace SciFigs

#endif // LEGENDFORMATPROPERTIES_H
