/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2005-07-04
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef LEGENDPROPERTIES_H
#define LEGENDPROPERTIES_H

#include <QGpGuiTools.h>
#include "ui_LegendProperties.h"
#include "SciFigsDLLExport.h"
#include "Legend.h"

namespace SciFigs {

class SCIFIGS_EXPORT LegendProperties : public PropertyWidget, private Ui::LegendProperties
{
  Q_OBJECT
public:
  LegendProperties( QWidget * parent=0 );

  enum Properties { Legend };

  const SciFigs::Legend& legend() {return _legend;}
  void setLegend( const SciFigs::Legend& legend );

  void setPropertySections( LegendTable::PropertySections s = LegendTable::All );

  void setReadOnlyText(bool ro);
private slots:
  void on_loadPalette_clicked();
  void on_savePalette_clicked();
  void on_interpoleColors_clicked();
  void on_grayColors_clicked();
  void on_colorColors_clicked();
  void on_penNumber_valueChanged(int);
  void on_oneColor_toggled(bool);
private:
  virtual int determineCustomWidgetType( int pid, QWidget * w, QWidget * label );
  virtual QVariant customWidgetValue( PropertyValue & );
  virtual bool connectCustomWidget( PropertyValue & );
  virtual bool setCustomWidget( PropertyValue &  p );

  SciFigs::Legend _legend;
};

} // namespace SciFigs

#endif // LEGENDPROPERTIES_H
